/*
 * Decompiled with CFR 0.152.
 */
package com.InitialImmortalSkill.skill.network;

import com.InitialImmortalSkill.skill.entity.ThunderEntity;
import com.InitialImmortalSkill.skill.helper.EffectHelper;
import com.InitialImmortalSkill.skill.helper.EntityHelper;
import com.InitialImmortalSkill.skill.helper.ParticleEffectHelper;
import com.InitialImmortalSkill.skill.helper.SkillHelper;
import com.InitialImmortalSkill.skill.network.AttackSkillMessage;
import com.InitialImmortalSkill.skill.network.MeritsMessage;
import com.InitialImmortalSkill.skill.network.MessageRegister;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class TreatmentSkillsMessage
implements IMessage {
    int key;

    public TreatmentSkillsMessage() {
    }

    public TreatmentSkillsMessage(int key) {
        this.key = key;
    }

    public void fromBytes(ByteBuf buf) {
        this.key = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.key);
    }

    public static class Handler
    implements IMessageHandler<TreatmentSkillsMessage, IMessage> {
        public IMessage onMessage(TreatmentSkillsMessage message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            NBTTagCompound nbtTagCompound = player.getEntityData();
            NBTTagCompound compound = nbtTagCompound.func_74775_l("skill");
            BlockPos pos2 = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            int i = message.key;
            String name = compound.func_74779_i("Key" + i);
            double attack = player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b();
            int skill = SkillHelper.getIncrease((EntityPlayer)player, name);
            List<String> strings = Arrays.asList(compound.func_74779_i("hasSkillList").split(","));
            WorldServer world = (WorldServer)player.field_70170_p;
            int power = player.getEntityData().func_74762_e("power");
            if (!name.equals("") && !compound.func_74767_n("Key" + i + "IsTick") && strings.contains(name)) {
                int health;
                EntityLivingBase entityLiving;
                if (name.equals("\u9633\u6728\u672f") && SkillHelper.isPower(power >= 50 - skill) && EntityHelper.isEntity(entityLiving = EntityHelper.getPlayerSeesEntity((EntityPlayer)player, 3.0))) {
                    health = (int)((double)entityLiving.func_110138_aP() * ((10.0 + (double)skill) / 100.0));
                    entityLiving.func_70606_j(entityLiving.func_110143_aJ() + (float)health);
                    AttackSkillMessage.Message(player, i, 50 - skill, 40 - skill, "\u9633\u6728\u672f");
                }
                if (name.equals("\u4e94\u9633\u5723\u624b") && SkillHelper.isPower(power >= 250 - skill * 10) && EntityHelper.isEntity(entityLiving = EntityHelper.getPlayerSeesEntity((EntityPlayer)player, 3.0))) {
                    int x;
                    health = (int)((double)entityLiving.func_110138_aP() * ((20.0 + (double)skill) / 100.0));
                    entityLiving.func_70606_j(entityLiving.func_110143_aJ() + (float)health);
                    int random = (int)Math.floor(Math.random() * (double)(3 + skill));
                    for (x = 0; x < 100; ++x) {
                        player.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, entityLiving.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v, 0.1, 0.1, 0.1, new int[0]);
                    }
                    for (x = 0; x < random; ++x) {
                        entityLiving.func_70690_d(new PotionEffect(EffectHelper.Beneficial[(int)Math.floor(Math.random() * (double)EffectHelper.Beneficial.length)], skill * 3 * 20, (int)Math.floor(Math.random() * (double)(skill * 3))));
                    }
                    AttackSkillMessage.Message(player, i, 250 - skill * 10, 60, "\u4e94\u9633\u5723\u624b");
                }
                if (name.equals("\u9752\u85e4\u9010\u6d4a") && SkillHelper.isPower(power >= 200 - skill * 7)) {
                    player.func_70674_bp();
                    player.func_70690_d(new PotionEffect(MobEffects.field_76444_x, (int)Math.floor(Math.random() * (double)(skill * 4)) * 20, skill * 4));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76432_h, skill * 4 * 20));
                    AttackSkillMessage.Message(player, i, 200 - skill * 7, 60 - skill * 3, "\u9752\u85e4\u9010\u6d4a");
                }
                if (name.equals("\u547d\u96f7") && SkillHelper.isPower(power >= 3200)) {
                    world.func_72838_d((Entity)new ThunderEntity((World)world, player.field_70165_t, player.field_70163_u, player.field_70161_v, false, 128, 255, 0));
                    player.func_70674_bp();
                    player.func_70606_j(player.func_110138_aP());
                    MessageRegister.instance.sendToServer((IMessage)new MeritsMessage());
                    player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 400, 6));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 400, 6));
                    AttackSkillMessage.Message(player, i, 3200, 120, "\u547d\u96f7");
                }
                if (name.equals("\u7384\u6c34\u82e5\u91cd") && SkillHelper.isPower(power >= 2500 - skill * 20)) {
                    int level = 0;
                    List<Entity> entities = EntityHelper.getSurroundingEntities(pos2, (World)world, skill + 5);
                    for (Entity entity : entities) {
                        if (!(entity instanceof EntityPlayer)) continue;
                        ++level;
                        EntityPlayer entityPlayer = (EntityPlayer)entity;
                        entityPlayer.func_70606_j((float)((double)entityPlayer.func_110143_aJ() + (20.0 + (double)skill) / 100.0 * (double)entityPlayer.func_110138_aP()));
                        ParticleEffectHelper.ball(2, new BlockPos(entityPlayer.field_70165_t, entityPlayer.field_70163_u - 5.0, entityPlayer.field_70161_v), world, EnumParticleTypes.WATER_WAKE);
                    }
                    player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 20 + skill * 2 * 20, level));
                    AttackSkillMessage.Message(player, i, 7800 - skill * 100, 150 - skill * 5, "\u7384\u6c34\u82e5\u91cd");
                }
                if (name.equals("\u5e76\u8482\u83b2\u751f") && SkillHelper.isPower(power >= 14000) && EntityHelper.isEntity(entityLiving = EntityHelper.getPlayerSeesEntity((EntityPlayer)player, 3.0))) {
                    world.func_72838_d((Entity)new ThunderEntity((World)world, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, false, 255, 255, 0));
                    player.func_70606_j((float)((double)player.func_110143_aJ() * 0.05));
                    entityLiving.getEntityData().func_74757_a("\u5e76\u8482\u83b2\u751f", true);
                    AttackSkillMessage.Message(player, i, 14000, 200 - skill * 5, "\u5e76\u8482\u83b2\u751f");
                }
            }
            return null;
        }
    }
}

